//
//  ItemsChainView.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 10/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// CRCollectionViewLayoutBase
//////////////////////////////////////////////////////////////////////
@class CRItemsCollectionView;

@interface CRCollectionViewLayoutBase : NSObject
{
@protected
	CGFloat	animationDuration;
	BOOL	wantAnimation;
	int		placeholderIndex;
	int		itemsSpace;
	
@protected
	BOOL	duringUpdate;
	BOOL	wantForcedPlaceholderPosition;
	BOOL	wantShowPlaceholder;
	NSPoint	centeringOffset;
	
@protected
	CRItemsCollectionView* assigned collView;
}

@property (nonatomic, assign) CGFloat	animationDuration;
@property (nonatomic, assign) BOOL		wantAnimation;
@property (nonatomic, assign) int		placeholderIndex;
@property (nonatomic, assign) int		itemsSpace;
@property (assign, readonly)  NSSize	contentScrollAreaSize;

- (void)setCollectionView:(CRItemsCollectionView*)view;

- (void)pushPlaceholderIndex:(int)placeholderIndex;				// sets new placeholder position wihtout animation, but animates all other views
- (void)discardPlaceholder;										// sets placeholder to -1 and DOES NO animation. [updateLayout] isn't called
- (NSUInteger)itemIndexAtMouseLocation:(NSPoint)mouseLocation;	// searches for an item at given index
- (NSPoint)positionForItemIndex:(NSInteger)itemIndex;			// computes position for given item index
- (void)updatePlaceholderPositionWithMouse:(BOOL)bPush;
- (void)updateCollectionLayout;

@end

//////////////////////////////////////////////////////////////////////
// CRCollectionViewLayoutGroupedBase
//////////////////////////////////////////////////////////////////////
typedef enum
{
	CRLayoutPlaceholderItem,
	CRLayoutPlaceholderGroupHeader
}
CRLayoutPlaceholderType;

@interface CRCollectionViewLayoutGroupedBase : CRCollectionViewLayoutBase
{
@protected
	CRLayoutPlaceholderType placeholderType; 
	int groupHeaderSpace;
}

@property (assign, readwrite) CRLayoutPlaceholderType placeholderType;
@property (assign, readwrite) int groupHeaderSpace;

- (NSView *)typedPlaceholderView;

@end